(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     21770,        656]*)
(*NotebookOutlinePosition[     22589,        687]*)
(*  CellTagsIndexPosition[     22516,        681]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["\<\
Extremos relativos, condicionados y absolutos. Derivaci\[OAcute]n impl\
\[IAcute]cita.\
\>", "Title"],

Cell[TextData[StyleBox[
"Departamento de An\[AAcute]lisis Matem\[AAcute]tico\nUniversidad de Granada\n\
Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez",
  FontSize->12]], "Author",
  TextAlignment->Left],

Cell[CellGroupData[{

Cell["Introducci\[OAcute]n", "Section"],

Cell["\<\
Lo que debes aprender en este cuaderno es lo siguiente.
Calcular extremos relativos de campos escalares de dos y tres variables.
Representar gr\[AAcute]ficamente funciones definidas impl\[IAcute]citamente.
Calcular derivadas y derivadas parciales de funciones de una o varias \
variables definidas impl\[IAcute]citamente.
Usar la teor\[IAcute]a de los multiplicadores de Lagrange para calcular \
extremos condicionados.
Calcular extremos absolutos en conjuntos compactos.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Extremos relativos", "Section"],

Cell[TextData[{
  StyleBox[
  "Como ya sabes, para calcular los extremos relativos de un campo escalar de \
varias variables, lo primero que hay que hacer es calcular  los puntos cr\
\[IAcute]ticos, es decir, los puntos donde se anula el vector gradiente; y \
despu\[EAcute]s estudiar la matriz hessiana en esos puntos. Veamos un \
ejemplo.\nSe trata de calcular los extremos relativos de la funci\[OAcute]n ",
    
    FontFamily->"Times New Roman"],
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = x\^3 + 3  x\ y\^2 - 15\ x - 12\ y\)]],
  ". Usaremos los comandos que ya hemos definido para el gradiente y la \
matriz hessiana."
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{
      \(Clear[f]\), ";", "\n", 
        \(\(grad[f_]\)[x_, y_] = {D[f[x, y], x], D[f[x, y], y]}\), ";", 
        "\n", 
        StyleBox[\(\(grad[f_]\)[{x_, y_}] = \(grad[f]\)[x, y]\),
          FontColor->RGBColor[1, 0, 0]], 
        StyleBox[";",
          FontColor->RGBColor[1, 0, 0]], 
        StyleBox[" ",
          FontColor->RGBColor[1, 0, 0]], 
        StyleBox[
          \( (*para\ que\ grad[f]\ pueda\ evaluarse\ en\ vectores\ {x, y}*) 
            \),
          FontColor->RGBColor[1, 0, 0]], "\[IndentingNewLine]", 
        \(\(H[f_]\)[x_, 
            y_] = {{D[f[x, y], {x, 2}], D[f[x, y], x, y]}, {D[f[x, y], x, y], 
              D[f[x, y], {y, 2}]}}\), ";", "\n", 
        StyleBox[\(\(H[f_]\)[{x_, y_}] = \(H[f]\)[x, y]\),
          FontColor->RGBColor[1, 0, 0]], 
        StyleBox[";",
          FontColor->RGBColor[1, 0, 0]]}], 
      StyleBox[" ",
        FontColor->RGBColor[1, 0, 0]], 
      StyleBox[
        \( (*para\ que\ H[f]\ pueda\ evaluarse\ en\ vectores\ {x, y}*) \),
        FontColor->RGBColor[1, 0, 0]]}]], "Input"],

Cell[BoxData[
    \(f[x_, y_] = x\^3 + 3\ x*y\^2 - 15  x - 12  y; 
    \n (*calculamos\ los\ puntos\ cr\[IAcute]ticos\ y\ los\ sacamos\ como\ una
          \ lista\ usando\ el\ comando\ de\ sustituci\[OAcute]n\  /. \ *) \n
    pcrit = {x, y} /. Solve[\(grad[f]\)[x, y] == {0, 0}, {x, y}]\)], "Input"],

Cell["\<\
Si hubi\[EAcute]ramos obtenido soluciones imaginarias deber\[IAcute]amos \
elegir solamente las soluciones reales. \
\>", "Text"],

Cell["\<\
Ahora estudiaremos la matriz hessiana en cada uno de los puntos \
cr\[IAcute]ticos. Primero evaluamos la matriz hesiana en dichos puntos.\
\>", "Text"],

Cell[BoxData[
    \(hesis = Map[H[f], pcrit]\)], "Input"],

Cell["\<\
Ahora necesitamos el comando \"Det[m]\" que proporciona el determinante de la \
matriz cuadrada m. Nuestro objetivo ser\[AAcute] calcular el determinante de \
la matriz hessiana en cada punto cr\[IAcute]tico. \
\>", "Text"],

Cell[BoxData[
    \(Map[Det, hesis]\)], "Input"],

Cell["\<\
Como el determinante de la matriz hesiana es negativo en los puntos (-1,-2) y \
(1,2) ya podemos asegurar que dichos puntos son puntos de silla. Nos queda \
por ver el primer elemento de la matriz hessiana en los puntos (-2,-1) y \
(2,1).\
\>", "Text"],

Cell[BoxData[
    \({\(\(H[f]\)[\(-2\), \(-1\)]\)[\([1, 1]\)], 
      \(\(H[f]\)[2, 1]\)[\([1, 1]\)]}\)], "Input"],

Cell["\<\
Concluimos que en (-2,-1) hay un m\[AAcute]ximo relativo y en (2,1) hay un m\
\[IAcute]nimo relativo. Podemos comprobar gr\[AAcute]ficamente los resultados \
obtenidos.\
\>", "Text"],

Cell[BoxData[
    \(\(Plot3D[f[x, y], {x, \(-3\), 3}, {y, \(-3\), 3}, 
      BoxRatios -> {1, 1, 1}]; \)\)], "Input"],

Cell[BoxData[
    \(\(ContourPlot[
        f[x, y], {x, \(-2.5\), 2.5}, {y, \(-2.5\), 2.5}];\)\)], "Input"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell["\<\
Escribe un programa que calcule y clasifique los puntos cr\[IAcute]ticos de \
un campo escalar de dos variables. Los c\[AAcute]lculos deben hacerse de \
forma num\[EAcute]rica.\
\>", "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  "En este ejercicio vamos a ver que una funci\[OAcute]n de dos variables \
puede tener infinitos m\[AAcute]ximos locales pero ning\[UAcute]n \
m\[IAcute]nimo local. Esto no puede ocurrir con funciones de una variable, \
\[DownQuestion]verdad? La funci\[OAcute]n es  ",
  Cell[BoxData[
      \(TraditionalForm
      \`f(x, y) = 
        \(\[ExponentialE]\^\(\(-x\)\ \)\)(
          x\ \[ExponentialE]\^\(-x\) + \ cos\ y)\)]],
  ".\n1.  Define la funci\[OAcute]n y repres\[EAcute]ntala \
gr\[AAcute]ficamente en la regi\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\) \[LessEqual] x \[LessEqual] 4, \ 
      \(-4\) \[Pi] \[LessEqual] y \[LessEqual] 4  \[Pi]\)]],
  ". Haz tambi\[EAcute]n, con \"ContourPlot\"  un gr\[AAcute]fico de las \
curvas de nivel en la misma regi\[OAcute]n.\n2. Calcula  los puntos cr\
\[IAcute]ticos de ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ". Para ello calcula  primero ",
  Cell[BoxData[
      \(TraditionalForm\`D[f[x, y], y]\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`D[f[x, \[Pi]], x]\)]],
  "  y ",
  Cell[BoxData[
      \(TraditionalForm\`D[f[x, 0], x]\)]],
  "  y f\[IAcute]jate d\[OAcute]nde se anulan (puedes ayudarte con una \
representaci\[OAcute]n gr\[AAcute]fica). Ahora ya puedes deducir \
cu\[AAcute]les son los puntos cr\[IAcute]ticos de ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  ".\n3. Gr\[AAcute]ficamente, es evidente que los puntos cr\[IAcute]ticos \
tienen que ser m\[AAcute]ximos locales. Justif\[IAcute]calo."
}], "ExerciseText",
  FontFamily->"Times New Roman"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Curvas y superficies definidas impl\[IAcute]citamente", "Section"],

Cell["\<\
Puedes representar curvas impl\[IAcute]citamente definidas con el comando \
\"ImplicitPlot[ecuacion,{x,xmin,xmax}] \". Antes debemos cargar el paquete \
correspondiente.\
\>", "Text"],

Cell[BoxData[
    \(<< \ Graphics`ImplicitPlot`\)], "Input"],

Cell[BoxData[
    \(\(ImplicitPlot[x\^2\/9 + y\^2\/3 == 1, {x, \(-3\), 3}];\)\)], "Input"],

Cell[TextData[{
  "Ten en cuenta que una ecuaci\[OAcute]n de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = 0\)]],
  " puede representar \"algo m\[AAcute]s\" que una curva."
}], "Text"],

Cell[BoxData[
    \(g[x_, y_] = 
      \(-12\) + 16\ x + 2\ x\^2 - 8\ x\^3 + 2\ x\^4 + 11\ y\^2 - 
        20\ x\ y\^2 + 7\ x\^2\ y\^2 + 5\ y\^4; \n
    ImplicitPlot[g[x, y] == 0, {x, \(-6\), 6}, PlotRange -> All]; \)], "Input"],

Cell["\<\
Para representar superficies impl\[IAcute]citamente definidas hay que cargar \
el paquete siguiente que pone a nuestra disposici\[OAcute]n el comando \
ContourPlot3D[ ] que es el an\[AAcute]logo en tres dimensiones de \
ContourPlot[ ]. \
\>", "Text"],

Cell["<<Graphics`ContourPlot3D`", "Input",
  CellTags->"S5.30.1"],

Cell[BoxData[
    \(\(\(ContourPlot3D[2  x^2 + y^2 - z^2 - 1, \n
      \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ {x, \(-2\), 2}, \ {y, \(-2\), 2}, 
      \ {z, \(-2\), 2}, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ 
      PlotPoints -> {{5, 7}, {5, 7}, {5, 7}}]; 
    \) (*\ Hiperboloide\ de\ una\ hoja\ *) \)\)], "Input"],

Cell[BoxData[
    \(\(ContourPlot3D[
        z\^2 + \((2 - \@\(x\^2 + y\^2\))\)\^2 - 
          1, \[IndentingNewLine]\t{x, \(-3\), 3}, {y, \(-3\), 3}, {z, \(-1\), 
          1}, \[IndentingNewLine]\t
        PlotPoints -> {{5, 7}, {5, 7}, {5, 7}}];\)\)], "Input"],

Cell[BoxData[
    \(\(\(ContourPlot3D[
      x^2 + 2\ y^2 + 3\ z^2 - 3, \[IndentingNewLine]\t\t{x, \(-2\), 
        2}, {y, \(-2\), 2.2}, {z, \(-1\), 
        1}, \[IndentingNewLine]\t\tPlotPoints -> {{5, 7}, {5, 7}, {5, 
            7}}]\)\(;\)\(\ \)\( (*\ elipsoide\ *) \)\)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Derivaci\[OAcute]n impl\[IAcute]cita", "Section",
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " sabe derivar impl\[IAcute]citamente. Consideremos la funci\[OAcute]n."
}], "Text"],

Cell[BoxData[
    \(\(g[x_, y_] = 
      \(-3\) + 4  x + 8  x^2 - 12  x^3 + 3  x^4 + 14  y^2 - 20  x\ y^2 + 
        8\ x^2\ y^2 + 5  y^4; \)\)], "Input"],

Cell[BoxData[{
    \(\ g[3/2, \@3/2] == 0\  (*
      este\ punto\ est\[AAcute]\ en\ la\ curva\ g[x, y] = 0*) \), 
    \(\((D[g[x, y], y] /. {x -> 3/2, y -> \@3/2})\) \[NotEqual] 0\  (*
      esta\ derivada\ parcial\ no\ se\ anula\ en\ \((3/2, \@3/2)\)*) \)}], 
  "Input"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(Deducimos\ que\ la\ igualdad\ \(g(x, y)\)\), "=", 
          RowBox[{
          "0", " ", "define", " ", "a", " ", "y", " ", "como", " ", 
            "funci\[OAcute]n", " ", "de", " ", "x", " ", "en", " ", "un", " ",
             "entorno", " ", "del", " ", "punto", 
            FormBox[\(a = 3/2\),
              "TraditionalForm"]}]}], ",", 
        RowBox[{"siendo", 
          RowBox[{
            FormBox[\(y(3/2) = \@3/2\),
              "TraditionalForm"], "."}]}]}], TraditionalForm]], "Text"],

Cell[BoxData[
    \(\(\(\(h[x_] = g[x, y[x]];\)\n
    \(h'\)[x]\)\(\ \)\)\)], "Input"],

Cell[BoxData[
    \(\(y'\)[
        x_] = \(\(\(y'\)[
          x]\)\(/.\)\(\(Solve[\(h'\)[x] \[Equal] 0, \(y'\)[
              x]]\)[\([1]\)]\)\( (*\ calculamos\ \(y'\)[x]\ cosa\ que, \ 
          en\ general, \ 
          no\ podr\[AAcute]\ hacerse\ de\ forma\ expl\[IAcute]cita\ *) \
\)\)\)], "Input"],

Cell[BoxData[
    \(\(\(\(y'\)[3/2]\)\(\ \)\)\)], "Input"],

Cell[TextData[{
  "Para obtener el valor de y'[3/2] debemos sustituir y(3/2) por ",
  Cell[BoxData[
      \(TraditionalForm\`\@3/2\)]],
  ". Podemos hacerlo con una regla de sustituci\[OAcute]n o, m\[AAcute]s \
sencillo, definir ",
  Cell[BoxData[
      FormBox[
        FormBox[\(y(3/2) = \@3/2\),
          "TraditionalForm"], TraditionalForm]]],
  "."
}], "Text"],

Cell[BoxData[
    \(y[3/2] = \@3/2; \n\(y'\)[3/2]\)], "Input"],

Cell["Comprobamos el resultado obtenido.", "Text"],

Cell[BoxData[
    \(\(-\(D[g[x, y], x]\/D[g[x, y], y]\)\) /. {x -> 3/2, 
        y -> \@3/2}\)], "Input"],

Cell[TextData[{
  "El c\[AAcute]lculo de derivadas de orden superior no ofrece dificultad \
para ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(\(y'\)'\)[x_] = D[\(y'\)[x], x]\)], "Input"],

Cell[BoxData[
    \(\(\(\(\(y'\)'\)[3/2]\)\(\ \)\)\)], "Input"],

Cell[BoxData[
    \(Clear["\<@\>"]\)], "Input"],

Cell["Consideremos ahora la funci\[OAcute]n siguiente.", "Text"],

Cell[BoxData[
    \(g[x_, y_] = 
      \(-12\) + 16\ x + 2\ x\^2 - 8\ x\^3 + 2\ x\^4 + 11\ y\^2 - 
        20\ x\ y\^2 + 7\ x\^2\ y\^2 + 5\ y\^4; \n
    graf = ImplicitPlot[g[x, y] == 0, {x, \(-6\), 6}, PlotRange -> All]; \)], 
  "Input"],

Cell["\<\
Esta gr\[AAcute]fica no es una curva pero parece localmente una curva excepto \
en los puntos donde se cortan la circunferencia y la elipse. Vamos a \
comprobar que en dichos puntos se anula el vector gradiente (tambi\[EAcute]n \
se anula en otros puntos) por lo que en ellos no puede aplicarse el teorema \
de la funci\[OAcute]n impl\[IAcute]cita. De hecho, son justamente esos puntos \
donde ninguna variable queda definida localmente como funci\[OAcute]n de la \
otra.\
\>", "Text"],

Cell[BoxData[
    \(Solve[{D[g[x, y], x], D[g[x, y], y]} \[Equal] {0, 0}, {x, 
        y}]\)], "Input"],

Cell["\<\
Demasiado complicado. Calculemos las soluciones num\[EAcute]ricamente y \
elijamos solamente las reales.\
\>", "Text"],

Cell[BoxData[{
    \({x, y} /. 
      NSolve[{D[g[x, y], x], D[g[x, y], y]} \[Equal] {0, 0}, {x, y}]\), 
    \(eligereal[{x_, y_}] := 
      \((Im[x] \[Equal] 0)\) && \((Im[y] \[Equal] 0)\)\), 
    \(puntos = Select[%%, eligereal]\)}], "Input"],

Cell["Representemos dichos puntos sobre la gr\[AAcute]fica anterior.", "Text"],

Cell[BoxData[
    \(\(Show[{graf, 
        Graphics[{PointSize[ .02], Hue[0], Map[Point, puntos]}]}]; \)\)], 
  "Input"],

Cell["\<\
Hemos comprobado que, efectivamente, donde se cortan la circunferencia y la \
elipse el gradiente se anula.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell[TextData[{
  "Calcula las derivadas parciales de primer y segundo orden de ",
  Cell[BoxData[
      \(TraditionalForm\`z = z(x, y)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`z(x, y)\)]],
  " es la funci\[OAcute]n definida impl\[IAcute]citamente por ",
  Cell[BoxData[
      \(TraditionalForm\`z\^3 + z\ \[ExponentialE]\^x + cos\ y = 0\)]],
  ". Calcula dichas derivadas parciales en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\) = \((0, \[Pi]/2)\)\)]],
  "."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Extremos condicionados", "Section"],

Cell[TextData[{
  "Hagamos un problema de extremos condicionados. Se trata de calcular el m\
\[AAcute]ximo y el m\[IAcute]nimo absolutos de ",
  Cell[BoxData[
      \(TraditionalForm\`x\^3 + y\^3 + z\^3\)]],
  " en el elipsoide ",
  Cell[BoxData[
      \(TraditionalForm\`4  x\^2 + 9  y\^2 + 16  z\^2 - 25 = 0\)]],
  ". "
}], "Text"],

Cell[BoxData[
    \(\(\(F[x_, y_, z_, \[Lambda]_] = 
      \((x^3 + y^3 + z^3)\) + 
        \[Lambda]\ \((4  x^2 + 9  y^2 + 16  z^2 - 25)\); 
    \) (*\ funci\[OAcute]n\ de\ Lagrange\ *) \)\)], "Input"],

Cell[BoxData[
    \(\(gradF[x_, y_, z_, \[Lambda]_] := {D[F[x, y, z, \[Lambda]], x], 
        D[F[x, y, z, \[Lambda]], y], D[F[x, y, z, \[Lambda]], z], 
        D[F[x, y, z, \[Lambda]], \[Lambda]]}; \)\)], "Input"],

Cell[BoxData[
    \(pcritic = 
      Solve[gradF[x, y, z, \[Lambda]] \[Equal] {0, 0, 0, 0}, {x, y, z, 
          \[Lambda]}]\)], "Input"],

Cell[TextData[{
  "La existencia de los extremos absolutos buscados est\[AAcute] garantizada \
por la compacidad de la esfera y dichos extremos tienen que alzanzarse en \
alguno de los puntos obtenidos. Para evaluar ",
  Cell[BoxData[
      \(TraditionalForm\`x\^3 + y\^3 + z\^\(3\ \)\)]],
  "nos est\[AAcute]n sobrando las \[Lambda] as\[IAcute] que las quitamos y \
evaluamos."
}], "Text"],

Cell[BoxData[
    \(pcrit = {x, y, z} /. pcritic\)], "Input"],

Cell[BoxData[
    \(f[{x_, y_, z_}] = x^3 + y^3 + z^3; \n\nvalores = Map[f, pcrit]\)], 
  "Input"],

Cell[BoxData[
    \(\(\(Max[valores]\ \) (*\ m\[AAcute]ximo\ absoluto\ *) \)\)], "Input"],

Cell[BoxData[
    \(\(\(Min[valores]\ \) (*\ m\[IAcute]nimo\ absoluto\ *) \)\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["C\[AAcute]lculo de extremos absolutos en un compacto", "Section"],

Cell["\<\
Finalmente, haremos un ejercicio que combina extremos relativos y \
condicionados. Se considera la funci\[OAcute]n \
\>", "Text"],

Cell[BoxData[
    \(TraditionalForm\`f(x, y, 
        z) = \(\@48\) 
          x\ y\ z\  - \((1 - x\^2 - y\^2 - z\^2)\)\^\(3/2\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "definida en la bola cerrada unidad: ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 + z\^2 \[LessEqual] 1\)]],
  ". Se trata de calcular su m\[AAcute]ximo absoluto y su m\[IAcute]nimo \
absoluto en dicha bola. \nEste problema consta realmente de dos problemas: \
calcular los extremos relativos de la funci\[OAcute]n en la bola abierta y \
calcular los extremos de la funci\[OAcute]n en la frontera de la bola, es \
decir, en la esfera unidad (un problema de extremos condicionados). Empecemos \
por el primero."
}], "Text"],

Cell[BoxData[
    \(f[x_, y_, z_] = 
      \(\@48\) x\ y\ z\  - \((1 - x^2 - y^2 - z^2)\)^\((3/2)\); \n
    pt = {x, y, z} /. 
        Solve[{D[f[x, y, z], x], D[f[x, y, z], y], D[f[x, y, z], z]} == {0, 
              0, 0}, \n\t\t\t{x, y, z}]\)], "Input"],

Cell[BoxData[{
    \(\(Hessin[f_]\)[x_, y_, z_] = 
      Outer[D, {D[f[x, y, z], x], D[f[x, y, z], y], D[f[x, y, z], z]}, {x, y, 
          z}] (*\ La\ matriz\ hessiana . \ Observa\ que\ no\ est\[AAcute]\ 
        definida\ en\ la\ esfera\ unidad\ *) \), 
    \(\(\(Hessin[f_]\)[{x_, y_, z_}] = \(Hessin[f]\)[x, y, z]; \)\)}], "Input"],

Cell[BoxData[
    \(\(normamenorqueuno[x_] := \@\(x . x\) < \(1\ \ \ \) (*\ 
      criterio\ para\ seleccionar\ los\ puntos\ con\ norma\ eucl\[IAcute]dea
          \  < 1\ *) ; \n\t\t\t\n
    prt = Select[pt, normamenorqueuno]\n (*\ 
      seleccionamos\ entre\ los\ puntos\ cr\[IAcute]ticos\ los\ que\ 
        est\[AAcute]n\ en\ el\ interior\ de\ la\ bola\ *) \)\)], "Input"],

Cell[BoxData[{
    \(matriceshesianas = Map[Hessin[f], prt]\n (*\ 
      calculamos\ las\ mateices\ hesianas\ en\ cada\ punto\ *) \), 
    \(valorespropiosmatriceshesianas = Map[Eigenvalues, matriceshesianas]\n (*
      \ calculamos\ los\ valores\ propiios\ de\ las\ matices\ hesianas\ *) 
      \)}], "Input"],

Cell["\<\
A la vista de este resultado, se sigue que hay un \[UAcute]nico extremo \
relativo dentro de la bola que se encuentra en el origen y corresponde a un m\
\[IAcute]nimo. Calculemos los extremos de la funci\[OAcute]n en la esfera \
unidad.\
\>", "Text"],

Cell[BoxData[
    \(F[x_, y_, z_, \[Lambda]_] = 
      f[x, y, z] + \[Lambda] \((x^2 + y^2 + z^2 - 1)\); \n
    pcond = Solve[{D[F[x, y, z, \[Lambda]], x], D[F[x, y, z, \[Lambda]], y], 
            D[F[x, y, z, \[Lambda]], z], 
            D[F[x, y, z, \[Lambda]], \[Lambda]]} == {0, 0, 0, 0}, {x, y, z, 
          \[Lambda]}]\)], "Input"],

Cell[TextData[{
  "Ahora lo que hay que hacer es calcular los valores de la funci\[OAcute]n ",
  
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " en los puntos de la esfera unidad obtenidos. Para evaluar ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " sobran los valores de \[Lambda]. Los quitamos y evaluamos. "
}], "Text"],

Cell[BoxData[
    \(npcon = {x, y, z} /. pcond\)], "Input"],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    \(f[{x_, y_, z_}] = f[x, y, z]; \n\nMap[f, npcon]\)], "Input"],

Cell[TextData[{
  "Como ",
  Cell[BoxData[
      \(TraditionalForm\`f(0, 0, 0) = \(-1\)\)]],
  " (no debemos olvidar este valor, aunque en este caso no influye en el \
resulado final), concluimos que al m\[AAcute]ximo absoluto de ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " es ",
  Cell[BoxData[
      \(TraditionalForm\`4\/3\)]],
  " y el m\[IAcute]nimo absoluto es ",
  Cell[BoxData[
      \(TraditionalForm\`\(-\(4\/3\)\)\)]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[{
  "Calcula los valores m\[AAcute]ximo y m\[IAcute]nimo absolutos de ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = 
        x\^2 + 5  x\^2 + 6  x\ y\  - 22\ x - 26\ y\  + 37\)]],
  " en la regi\[OAcute]n del plano dada por ",
  Cell[BoxData[
      \(TraditionalForm\`K = {\((x, 
              y)\) \[Element] \(\(\[DoubleStruckCapitalR]\^2\) : \ 
              1 \[LessEqual] x\^2 + 2  y\^2 \[LessEqual] 12\)}\)]],
  " y representa la gr\[AAcute]fica de ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " cerca del punto donde se alcanza el m\[IAcute]nimo absoluto."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 5", "Exercise"],

Cell[TextData[{
  "Calcula los valores m\[AAcute]ximo y m\[IAcute]nimo absolutos que alcanza \
la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y, z) = 9  x\^2 + 6  y\^2 - 4  z\^2\)]],
  " sobre el elipsoide de ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 + 6  z\^2 = 4\)]],
  "."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 1280}, {0, 895}},
WindowSize->{1251, 820},
WindowMargins->{{2, Automatic}, {Automatic, 2}},
Magnification->1,
StyleDefinitions -> "Classroom.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S5.30.1"->{
    Cell[9260, 269, 65, 1, 47, "Input",
      CellTags->"S5.30.1"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S5.30.1", 22422, 674}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1709, 49, 111, 3, 55, "Title"],
Cell[1823, 54, 204, 4, 57, "Author"],

Cell[CellGroupData[{
Cell[2052, 62, 39, 0, 55, "Section"],
Cell[2094, 64, 495, 9, 158, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2626, 78, 37, 0, 55, "Section"],
Cell[2666, 80, 645, 13, 70, "Text"],
Cell[3314, 95, 1095, 27, 115, "Input"],
Cell[4412, 124, 300, 4, 81, "Input"],
Cell[4715, 130, 139, 3, 26, "Text"],
Cell[4857, 135, 161, 3, 26, "Text"],
Cell[5021, 140, 57, 1, 48, "Input"],
Cell[5081, 143, 233, 4, 26, "Text"],
Cell[5317, 149, 48, 1, 48, "Input"],
Cell[5368, 152, 262, 5, 43, "Text"],
Cell[5633, 159, 114, 2, 48, "Input"],
Cell[5750, 163, 192, 4, 26, "Text"],
Cell[5945, 169, 117, 2, 48, "Input"],
Cell[6065, 173, 107, 2, 48, "Input"],

Cell[CellGroupData[{
Cell[6197, 179, 31, 0, 38, "Exercise"],
Cell[6231, 181, 208, 4, 26, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6476, 190, 31, 0, 38, "Exercise"],
Cell[6510, 192, 1576, 37, 130, "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8135, 235, 72, 0, 55, "Section"],
Cell[8210, 237, 193, 4, 26, "Text"],
Cell[8406, 243, 60, 1, 48, "Input"],
Cell[8469, 246, 90, 1, 60, "Input"],
Cell[8562, 249, 201, 5, 26, "Text"],
Cell[8766, 256, 228, 4, 64, "Input"],
Cell[8997, 262, 260, 5, 43, "Text"],
Cell[9260, 269, 65, 1, 47, "Input",
  CellTags->"S5.30.1"],
Cell[9328, 272, 303, 5, 81, "Input"],
Cell[9634, 279, 264, 5, 89, "Input"],
Cell[9901, 286, 289, 5, 81, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10227, 296, 88, 1, 55, "Section"],
Cell[10318, 299, 154, 4, 26, "Text"],
Cell[10475, 305, 154, 3, 48, "Input"],
Cell[10632, 310, 271, 5, 72, "Input"],
Cell[10906, 317, 563, 13, 29, "Text"],
Cell[11472, 332, 86, 2, 64, "Input"],
Cell[11561, 336, 304, 7, 48, "Input"],
Cell[11868, 345, 58, 1, 48, "Input"],
Cell[11929, 348, 366, 11, 27, "Text"],
Cell[12298, 361, 62, 1, 68, "Input"],
Cell[12363, 364, 50, 0, 26, "Text"],
Cell[12416, 366, 105, 2, 60, "Input"],
Cell[12524, 370, 169, 6, 26, "Text"],
Cell[12696, 378, 66, 1, 48, "Input"],
Cell[12765, 381, 63, 1, 48, "Input"],
Cell[12831, 384, 47, 1, 48, "Input"],
Cell[12881, 387, 64, 0, 26, "Text"],
Cell[12948, 389, 238, 5, 64, "Input"],
Cell[13189, 396, 495, 8, 60, "Text"],
Cell[13687, 406, 103, 2, 48, "Input"],
Cell[13793, 410, 128, 3, 26, "Text"],
Cell[13924, 415, 244, 5, 81, "Input"],
Cell[14171, 422, 78, 0, 26, "Text"],
Cell[14252, 424, 120, 3, 48, "Input"],
Cell[14375, 429, 131, 3, 26, "Text"],

Cell[CellGroupData[{
Cell[14531, 436, 31, 0, 38, "Exercise"],
Cell[14565, 438, 517, 14, 43, "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[15131, 458, 41, 0, 55, "Section"],
Cell[15175, 460, 333, 9, 26, "Text"],
Cell[15511, 471, 202, 4, 48, "Input"],
Cell[15716, 477, 214, 3, 48, "Input"],
Cell[15933, 482, 137, 3, 48, "Input"],
Cell[16073, 487, 390, 8, 43, "Text"],
Cell[16466, 497, 61, 1, 48, "Input"],
Cell[16530, 500, 98, 2, 81, "Input"],
Cell[16631, 504, 89, 1, 48, "Input"],
Cell[16723, 507, 89, 1, 48, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16849, 513, 71, 0, 55, "Section"],
Cell[16923, 515, 139, 3, 29, "Text"],
Cell[17065, 520, 165, 4, 30, "Text"],
Cell[17233, 526, 551, 10, 79, "Text"],
Cell[17787, 538, 256, 5, 92, "Input"],
Cell[18046, 545, 335, 5, 90, "Input"],
Cell[18384, 552, 377, 6, 112, "Input"],
Cell[18764, 560, 310, 5, 110, "Input"],
Cell[19077, 567, 260, 5, 29, "Text"],
Cell[19340, 574, 339, 6, 70, "Input"],
Cell[19682, 582, 335, 9, 29, "Text"],
Cell[20020, 593, 59, 1, 50, "Input"],
Cell[20082, 596, 26, 0, 50, "Input"],
Cell[20111, 598, 80, 1, 90, "Input"],
Cell[20194, 601, 458, 15, 29, "Text"],

Cell[CellGroupData[{
Cell[20677, 620, 31, 0, 38, "Exercise"],
Cell[20711, 622, 613, 14, 43, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21361, 641, 31, 0, 38, "Exercise"],
Cell[21395, 643, 347, 9, 26, "ExerciseText"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

